<?php

namespace Modules\ManualDeposit\Http\Controllers\User;

use App\Models\Deposit;
use App\Models\ManualDepositMethod;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Nwidart\Modules\Facades\Module;

class ManualDepositController extends Controller
{
    //return view for manaul payment
    public function manualPay()
    {
        $check = checkAddon('manualdeposit');
        $status = $check['status'] ?? 'fail' ;
        if ($status  == 'fail') {
            $module = Module::find('manualdeposit');
            $module->disable();
        }
        if (session()->has('amount') && session()->has('method_id') && session()->has('converted_amount')) {
            $page_title = 'Manual Payment';
            $amount = session()->get('amount');
            $method_id = session()->get('method_id');
            $converted_amount = session()->get('converted_amount');
            $payment_method = ManualDepositMethod::where('id', $method_id)->first();
            $currency = session()->get('currency');
            $charge = session()->get('charge');
            return view('manualdeposit::themes.cryptic.manual', compact(
                'page_title',
                'amount',
                'converted_amount',
                'payment_method',
                'currency',
                'charge'

            ));
        } else {
            return redirect(route('user.deposit.new'))->with('fail', 'Please select payment method first');
        }
    }

    //save manual payment
    public function saveManualPayment(Request $request)
    {
        $check = checkAddon('manualdeposit');
        $status = $check['status'] ?? 'fail' ;
        if ($status  == 'fail') {
            $module = Module::find('manualdeposit');
            $module->disable();
        }
        //validate form data
        $request->validate([
            'payment_screenshot' => 'required|mimes:jpg,jpeg,png|max:10000'
        ]);

        //get the method id and check the type of manaul payment method
        $method = ManualDepositMethod::where('id', session()->get('method_id'))->first();

        //retrieve crypto specific params and save to database
        $amount = session()->get('amount');
        $converted_amount = session()->get('converted_amount');
        $currency = session()->get('currency');
        $charge = session()->get('charge');

        //upload  payment screenshot
        $payment_screenshot = uploadImage($request->file('payment_screenshot'), 'deposits');

        //save deposit table
        $save_deposit = new Deposit();
        $save_deposit->user_id = user('id');
        $save_deposit->amount = $amount;
        $save_deposit->converted_amount = $converted_amount;
        $save_deposit->currency = $currency;
        $save_deposit->charge = $charge;
        $save_deposit->method = $method->name;
        $save_deposit->status = 'pending';
        $save_deposit->payment_screenshot = $payment_screenshot;
        $save_deposit->additional_info = $request->additional_info;
        $save = $save_deposit->save();

        if ($save) {
            //send email
            sendNewDepositEmail($amount, $converted_amount, $currency, $charge, $method->name, 'pending');

            //delete params from session
            session()->pull('amount');
            session()->pull('converted_amount');
            session()->pull('currency');
            session()->pull('charge');



            //redirect with success
            return redirect(route('user.deposit.index'))->with('success', 'Your deposit request has been received, please wait while an admin varifies your payment');
        } else {
            return back()->with('fail', 'Your deposit failed, please try again');
        }
    }

    //cancel manaul payment
    public function cancelManualPayment(Request $request)
    {
        $check = checkAddon('manualdeposit');
        $status = $check['status'] ?? 'fail' ;
        if ($status  == 'fail') {
            $module = Module::find('manualdeposit');
            $module->disable();
        }
        //get the method id and check the type of manaul payment method
        $method = ManualDepositMethod::where('id', session()->get('method_id'))->first();

        //retrieve crypto specific params and save to database
        $amount = session()->get('amount');
        $converted_amount = session()->get('converted_amount');
        $currency = session()->get('currency');
        $charge = session()->get('charge');

        //save deposit table
        $save_deposit = new Deposit();
        $save_deposit->user_id = user('id');
        $save_deposit->amount = $amount;
        $save_deposit->converted_amount = $converted_amount;
        $save_deposit->currency = $currency;
        $save_deposit->charge = $charge;
        $save_deposit->method = $method->name;
        $save_deposit->status = 'cancelled';

        $save = $save_deposit->save();

        if ($save) {
            //delete params from session
            session()->pull('amount');
            session()->pull('converted_amount');
            session()->pull('currency');
            session()->pull('charge');


            //redirect with success
            return redirect(route('user.deposit.index'))->with('success', 'Your deposit request has been cancelled');
        } else {
            return back()->with('fail', 'Your deposit cancellation failed, please try again');
        }
    }
}
