<?php


/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/


use Illuminate\Support\Facades\Route;
use Modules\ManualDeposit\Http\Controllers\Admin\DepositMethodController;
use Modules\ManualDeposit\Http\Controllers\ManualDepositInstallerController;
use Modules\ManualDeposit\Http\Controllers\User\ManualDepositController;


//installation route for this addon
Route::middleware(['adminAuthCheck', 'adminLoginOtpCheck'])->group(function(){
    Route::get('admin/manualdeposit/install', [ManualDepositInstallerController::class, 'install']);
  });
  
//Admin manual deposit route starts here

Route::middleware(['adminAuthCheck', 'adminLoginOtpCheck', 'manualDepositCheck'])->group(function(){
    //Deposit Method  Routes
    Route::prefix('admin/deposit-method')->name('admin.deposit-method.')->group(function(){
        Route::get('/', [DepositMethodController::class, 'index'])->name('index');
        Route::get('new', [DepositMethodController::class, 'addNew'])->name('new');
        Route::post('new', [DepositMethodController::class, 'addNewValidate'])->name('new.validate');
        Route::post('cancel', [DepositMethodController::class, 'cancel'])->name('cancel');
        Route::get('edit/{id}', [DepositMethodController::class, 'editMethod'])->name('edit-method');
        Route::post('edit', [DepositMethodController::class, 'editMethodValidate'])->name('edit-method.validate');
        Route::post('disable/{id}', [DepositMethodController::class, 'disableMethod'])->name('disable');
        Route::post('enable/{id}', [DepositMethodController::class, 'enableMethod'])->name('enable');
        Route::post('delete/{id}', [DepositMethodController::class, 'deleteMethod'])->name('delete');

    });
});


//User deposit route starts here
Route::middleware(['onlyLoggedIn', 'loginOtpCheck'])->prefix('user/deposits')->name('user.deposit.')->group(function(){
    Route::get('pay/manual', [ManualDepositController::class, 'manualPay'])->name('pay.manual')->middleware('manualDepositCheck');
    Route::post('pay/manual/save', [ManualDepositController::class, 'saveManualPayment'])->name('pay.manual.save');
    Route::post('pay/manual/cancel', [ManualDepositController::class, 'cancelManualPayment'])->name('pay.manual.cancel');
});
