@extends('themes.cryptic.layout.app')

@section('title')
<div class="w-full py-5">
    <div class="w-full flex justify-center">
        <div class="w-11/12 rounded-md bg-[#0e1726] p-2 md:p-4">
            <div class="flex justify-between items-center">
                <div>
                    {{--  Card header --}}
                    <h2 class="bg-transparent text-[#ebedf2] font-medium capitalize">
                        Edit Wallet
                    </h2>
                </div>

                <div>
                    <a href="{{ url()->previous() }}" class="flex justify-start items-center text-xs text-gray-400 hover:text-white">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M11 17l-5-5m0 0l5-5m-5 5h12" />
                        </svg>
                        <span>back</span>
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('content')
<div class="w-full py-5">
    <div class="w-full flex justify-center">
        <div class="w-11/12 rounded-md bg-[#0e1726] p-2 md:p-4">

            <div class="flex justify-end">
                <div>
                    <a href="#" class="flex justify-start items-center space-x-1 text-xs md:text-sm text-[#d1d5db] text-center px-5 py-2 my-2 bg-[#1b2e4b] hover:bg-gray-700 rounded-md">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M12 9v3m0 0v3m0-3h3m-3 0H9m12 0a9 9 0 11-18 0 9 9 0 0118 0z" />
                        </svg>
                        <span>Add New</span>
                    </a>
                </div>
            </div>
            <hr class="w-full border-b border-dotted border-gray-600 border">

            {{-- <div class="mt-3 flex justify-center">
                <div class="h-32 md:h-60 w-32 md:w-60 bg-blue-300 rounded-sm">
                    <img class="min-h-full min-w-full rounded-sm" src="put-me" alt="Wallet picture">
                </div>
            </div> --}}

            <form class="mt-2 p-2 md:p-4" action="{{ route('user.wallets.edit-validate') }}" method="POST">
                @csrf
                <input type="hidden" name="id" id="id" value="{{ $wallet->id }}">

                <div class="text-[#bfc9d4] text-xs md:text-sm">
                    <div class="w-full flex items-baseline space-x-1">
                        <label class="font-medium" for="wallet_name">Wallet Name:</label>
                        <input class="flex-grow px-2 md:px-4 pt-2 bg-[#0e1726] transition-colors duration-200 transform focus:outline-none border-b-2 border-slate-800 focus:border-b-slate-500" type="text" name="wallet_name" id="wallet_name" required value="{{ $wallet->name }}">
                    </div>
                    <span class="p-1 text-red-600">
                        @error('wallet_name') {{ $message }} @enderror
                    </span>
                </div>


                @if ($wallet->type == 'crypto')
                <div class="text-[#bfc9d4] text-xs md:text-sm">
                    <div class="w-full flex items-baseline space-x-1">
                        <label class="font-medium" for="wallet_address">Wallet Address:</label>
                        <input class="flex-grow px-2 md:px-4 pt-2 bg-[#0e1726] transition-colors duration-200 transform focus:outline-none border-b-2 border-slate-800 focus:border-b-slate-500" type="text" name="wallet_address" id="wallet_address" required value="{{ json_decode($wallet->info)->wallet_address }}">
                    </div>
                    <span class="p-1 text-red-600">
                        @error('wallet_address') {{ $message }} @enderror
                    </span>
                </div>
                <div class="text-[#bfc9d4] text-xs md:text-sm">
                    <div class="w-full flex items-baseline space-x-1">
                        <label class="font-medium" for="network_type">Network Type:</label>
                        <input class="flex-grow px-2 md:px-4 pt-2 bg-[#0e1726] transition-colors duration-200 transform focus:outline-none border-b-2 border-slate-800 focus:border-b-slate-500" type="text" name="network_type" id="netwok_type" value="{{ json_decode($wallet->info)->network_type }}" required>
                    </div>
                    <span class="p-1 text-red-600">
                        @error('network_type') {{ $message }} @enderror
                    </span>
                </div>

                @elseif ($wallet->type == 'bank')
                <div class="text-[#bfc9d4] text-xs md:text-sm">
                    <div class="w-full flex items-baseline space-x-1">
                        <label class="font-medium" for="bank_name">Bank Name:</label>
                        <input class="flex-grow px-2 md:px-4 pt-2 bg-[#0e1726] transition-colors duration-200 transform focus:outline-none border-b-2 border-slate-800 focus:border-b-slate-500" type="text" name="bank_name" id="bank_name" value="{{ json_decode($wallet->info)->bank_name }}" required>
                    </div>
                    <span class="p-1 text-red-600">
                        @error('bank_name') {{ $message }} @enderror
                    </span>
                </div>
                <div class="text-[#bfc9d4] text-xs md:text-sm">
                    <div class="w-full flex items-baseline space-x-1">
                        <label class="font-medium" for="account_name">Account Name:</label>
                        <input class="flex-grow px-2 md:px-4 pt-2 bg-[#0e1726] transition-colors duration-200 transform focus:outline-none border-b-2 border-slate-800 focus:border-b-slate-500" type="text" name="account_name" id="account_name" required value="{{ json_decode($wallet->info)->account_name }}">
                    </div>
                    <span class="p-1 text-red-600">
                        @error('account_name') {{ $message }} @enderror
                    </span>
                </div>
                <div class="text-[#bfc9d4] text-xs md:text-sm">
                    <div class="w-full flex items-baseline space-x-1">
                        <label class="font-medium" for="account_no">Account No:</label>
                        <input class="flex-grow px-2 md:px-4 pt-2 bg-[#0e1726] transition-colors duration-200 transform focus:outline-none border-b-2 border-slate-800 focus:border-b-slate-500" type="number" name="account_no" id="account_no" value="{{ json_decode($wallet->info)->account_no }}" required>
                    </div>
                    <span class="p-1 text-red-600">
                        @error('account_no') {{ $message }} @enderror
                    </span>
                </div>
                @elseif ($wallet->type == 'others')
                <div class="text-[#bfc9d4] text-xs md:text-sm">
                    <div class="w-full flex items-baseline space-x-1">
                        <label class="font-medium" for="payment_info">Payment Info:</label>
                        <textarea class="flex-grow px-2 md:px-4 pt-2 bg-[#0e1726] transition-colors duration-200 transform focus:outline-none border-b-2 border-slate-800 focus:border-b-slate-500" name="payment_info" id="payment_info">{{ json_decode($wallet->info)->payment_info }}</textarea>
                    </div>
                    <span class="p-1 text-red-600">
                        @error('payment_info') {{ $message }} @enderror
                    </span>
                </div>
                @endif

                <div class="w-full my-5 px-5">
                    <button type="submit" class="w-full text-xs md:text-sm text-[#d1d5db] text-center px-5 py-3 my-5 bg-[#1b2e4b] hover:bg-gray-700 rounded-md" href="{{ route('user.id.upload') }}">
                        Save wallet
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

@endsection